let currentSlide = 0;
const slideshow = document.getElementById('slideshow');
const slides = slideshow.querySelectorAll('.slideshow-item');
const totalSlides = slides.length;

/* Must match 'grid-auto-columns: 800px' in CSS. */
const slideWidth = 1440;

function showSlide(index) {
  if (index < 0) {
    currentSlide = totalSlides - 1;  // Wrap from first to last
  } else if (index >= totalSlides) {
    currentSlide = 0;               // Wrap from last to first
  } else {
    currentSlide = index;
  }

  // Negative offset to slide horizontally
  const offsetX = -(currentSlide * slideWidth);
  slideshow.style.transform = `translateX(${offsetX}px)`;
}

function nextSlide() {
  showSlide(currentSlide + 1);
}

function prevSlide() {
  showSlide(currentSlide - 1);
}

// Initialize to the first slide on page load
showSlide(0);
